import 'package:dartz/dartz.dart';
import 'package:google_maps_flutter/google_maps_flutter.dart';
import 'package:razinsoft_rider/core/errors/failure.dart';
import 'package:razinsoft_rider/data/models/driver_response/driver_response.dart';
import 'package:razinsoft_rider/data/repositories/base_repository.dart';
import 'package:razinsoft_rider/data/repositories/interfaces/driver_repo_interface.dart';
import 'package:razinsoft_rider/domain/interfaces/driver_service_interface.dart';

class DriverRepoImpl extends BaseRepository implements IDriverRepo {
  final IDriverService driverService;

  DriverRepoImpl({required this.driverService});
  @override
  Future<Either<Failure, DriverResponse>> getDrivers(
      {required LatLng? location}) async => await safeApiCall(() async {
      final response = await driverService.getDrivers(location: location);
      return DriverResponse.fromMap(response.data);
    });
}
